#include<Command/DAQBuilderMakeRunCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  MakeRunCommand::MakeRunCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  MakeRunCommand::MakeRunCommand( const MakeRunCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  MakeRunCommand::~MakeRunCommand()
  {
  }
  MakeRunCommand& MakeRunCommand::operator=( const MakeRunCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void MakeRunCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(!(arguments.size() == 2 || arguments.size() == 1 )){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","MakeRunCommand::operator()( const StringList& )");
      e -> insert("Usage : ","MakeRun "+_help);
      throw e;
    }
      DULong numEvents = 0;
     if(arguments.size()==2){
      String str(arguments[1]);
      if(!str.isDigit()){
	CommandException * e = 
	  new CommandException("Num events is not a digit");   
	e -> insert("Location","MakeRunCommand::executeCommand( const StringList& )");
	e -> insert("Usage : ",_type+_help);
	throw e;
       }
#if D_HAVE_ATOLL
          numEvents=(DULong)atoll(arguments[1].c_str());
#else
          numEvents=(DULong)atol(arguments[1].c_str());
#endif
      } 
      Run aRun(numEvents);
    try{
      RunRegistry::bind(arguments[0],aRun);
      //std::cout<<"numEvents="<<numEvents<<std::endl;
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","MakeRunCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
