#include<Command/DAQBuilderRunPauseCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  RunPauseCommand::RunPauseCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  RunPauseCommand::RunPauseCommand( const RunPauseCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  RunPauseCommand::~RunPauseCommand()
  {
  }
  RunPauseCommand& RunPauseCommand::operator=( const RunPauseCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void RunPauseCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","RunPauseCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunPause "+_help);
      throw e;
    }
    try{
      (RunRegistry::lookUp(arguments[0])).pause();
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","RunPauseCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
