#include<Command/DAQBuilderRunResumeCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  RunResumeCommand::RunResumeCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  RunResumeCommand::RunResumeCommand( const RunResumeCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  RunResumeCommand::~RunResumeCommand()
  {
  }
  RunResumeCommand& RunResumeCommand::operator=( const RunResumeCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void RunResumeCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","RunResumeCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunResume "+_help);
      throw e;
    }
    try{
      (RunRegistry::lookUp(arguments[0])).resume();
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","RunResumeCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
