#include<Command/DAQBuilderRunSetNumberOfEventsCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  RunSetNumberOfEventsCommand::RunSetNumberOfEventsCommand()
    :Command("<runName> <num events>")
  {
    _setType();
    _setParentClasses();
  }
  RunSetNumberOfEventsCommand::RunSetNumberOfEventsCommand( const RunSetNumberOfEventsCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  RunSetNumberOfEventsCommand::~RunSetNumberOfEventsCommand()
  {
  }
  RunSetNumberOfEventsCommand& RunSetNumberOfEventsCommand::operator=( const RunSetNumberOfEventsCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void RunSetNumberOfEventsCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 2 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","RunSetNumberOfEventsCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunSetNumberOfEvents "+_help);
      throw e;
    }
    String num(arguments[1]);
    if( !num.isDigit() ){
      CommandException * e = 
	new CommandException("Please Insert Digit!! for second argument");   
      e -> insert("Location","RunSetNumberOfEventsCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunSetNumberOfEvents "+_help);
      throw e;
      }
    try{
      (RunRegistry::lookUp(arguments[0])).setNumEvents(atoi(arguments[1].c_str()));
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","RunSetNumberOfEventsCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
