#include<Command/DAQBuilderRunShutdownCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  RunShutdownCommand::RunShutdownCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  RunShutdownCommand::RunShutdownCommand( const RunShutdownCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  RunShutdownCommand::~RunShutdownCommand()
  {
  }
  RunShutdownCommand& RunShutdownCommand::operator=( const RunShutdownCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void RunShutdownCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","RunShutdownCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunShutdown "+_help);
      throw e;
    }
    try{
      (RunRegistry::lookUp(arguments[0])).shutdown();
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","RunShutdownCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
