#include<Command/DAQBuilderRunStartCommand.hh>
#include<System/DAQBuilderRunRegistry.hh>
#include<Run/DAQBuilderRun.hh>
#include<System/DAQBuilderSystem.hh>
#include<Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  RunStartCommand::RunStartCommand()
    :Command("<runName>")
  {
    _setType();
    _setParentClasses();
  }
  RunStartCommand::RunStartCommand( const RunStartCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  RunStartCommand::~RunStartCommand()
  {
  }
  RunStartCommand& RunStartCommand::operator=( const RunStartCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void RunStartCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() != 1 ){
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","RunStartCommand::operator()( const StringList& )");
      e -> insert("Usage : ","RunStart "+_help);
      throw e;
    }
    try{
      (RunRegistry::lookUp(arguments[0])).start();
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","RunStartCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
