#include<Run/DAQBuilderAction.hh>
#include<System/DAQBuilderSystem.hh>
#include<System/DAQBuilderClassLoader.hh>
#include<System/DAQBuilderObjectRegistry.hh>
#include<Instance/DAQBuilderInstance.hh>
#include<Primitives/DAQBuilderInteger.hh>
#include<Command/DAQBuilderShellCommand.hh>
namespace DAQBuilder
{
  ShellCommand::ShellCommand()
    :Command("<shell format>")
  {
    _setType();
    _setParentClasses();
  }
  ShellCommand::ShellCommand( const ShellCommand& right )
    :Command(*((Command*)&right))
  {
    
  }
  ShellCommand::~ShellCommand()
  {
  }
  ShellCommand& ShellCommand::operator=( const ShellCommand & right)
  {
    *((Command*)this) = *((Command*)&right);
    return *this;
  }
  void ShellCommand::executeCommand( const StringList & arguments )
    throw (CommandException * )
  {
    if(arguments.size() < 1 )
      {
      CommandException * e = 
	new CommandException("invalid number of arguments!");   
      e -> insert("Location","ShellCommand::operator()( const StringList& )");
      e -> insert("Usage : ","Shell "+_help);
      throw e;
      }
    try{

      DString shellCommand;
      for(StringList::const_iterator iter = arguments.begin();
	  iter != arguments.end() ;
	  iter++)
	{
	  shellCommand += *iter;
	  shellCommand += ' ';
	}
      system(shellCommand.c_str());
    }catch (Exception * ex ){
      CommandException * e = 
	new CommandException("error occured");   
      e -> insert("Location","ShellCommand::operator()( const StringList& )");
      e -> insert("Error   : ",ex->toString());
      throw e;
    }
  }
}
