#include <DAQBuilderObject.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Exception/DAQBuilderNullPointerException.hh>
namespace DAQBuilder
{
  void              Object::_finalize()
  {;}
  
  Object*            Object::_clone() const
  {
    return new Object( *this );
  }
  void               Object::_lock() 
  {
    ::pthread_mutex_lock(&_mutex);
  }
  void               Object::_unLock() 
  {
    ::pthread_mutex_unlock(&_mutex);
  }
  void               Object::_tryLock() 
  {
    ::pthread_mutex_trylock(&_mutex);
  }
  
  const DULong&     Object::getReferenceCount()  const
  {
    return this -> _referenceCount;
  }
  
  const DString     Object::_toStringHeader() const 
  {
    DString aString;
    aString += "<";
    aString += this -> _type;
    aString += ">\n";
    aString +="ParentClasses : ";
    for(std::set<DString>::const_iterator iter = _parentClasses.begin();
	iter                                  != _parentClasses.end() ; 
	iter ++)
      {
	aString+=*iter;
	aString+=",";
      }
    aString += "\n";
    aString +="ReferenceCount: ";
    aString +=String::digitToString((DULong)_referenceCount);
    aString += "\n";
    aString += "=====================\n";
    return aString;
  }
  const DString     Object::_toStringFooter() const 
  {
    DString aString = "\n=====================";
    return aString;
  }
  const DString     Object::toString() const 
  {
    DString aString ;//= _toStringHeader();
    //aString += _toStringFooter();
    return aString;
  }
  void              Object::notify()
  {
    ::pthread_cond_signal(&_cond);
  }
  void              Object::notifyAll()
  {
    ::pthread_cond_broadcast(&_cond);
  }
  void              Object::wait()
  {
    ::pthread_cond_wait(&_cond,&_mutex);
  }
  void              Object::wait(DULong secs, DULong nanoSecs )
  {
    struct timespec requests = { secs , nanoSecs  };
    ::pthread_cond_timedwait(&_cond,&_mutex,&requests);
  }
  
  Object::Object()
    :_referenceCount((DULong)1)
  {
    pthread_attr_init(&_attribute);
    pthread_mutex_init(&_mutex,NULL);
    pthread_cond_init(&_cond,NULL);
    _setType();
    _setParentClasses();
  }
  
  Object::Object( const Object & right )
    :_mutex(right._mutex),_cond(right._cond),_parentClasses(right._parentClasses),
     _type(right._type),_referenceCount(1)
  {;}
  
  Object::~Object()
  {
    _finalize();
  }
  
  Object& Object::operator =(const Object & right )
  {
    _mutex           = right._mutex;
    _cond            = right._cond;
    _type            = right._type;
    _referenceCount  = right._referenceCount;
    return *this;
  }
  DBool   Object::operator   ==(const Object & right ) const 
  {
     if(!findParent(_type,&right))
      return false;
    return _type       == right._type;
  }
  DBool   Object::operator   !=(const Object & right ) const 
  {
     if(!findParent(_type,&right))
      return true;
    return _type       != right._type;
  }
  
  DBool              findParent(const DString& parentName, const Object* o)
               //       throw( NullPointerException *)
  {
   if( o == NULL){
       NullPointerException * e = new NullPointerException("Illegal Pointer ");
       e -> insert("Location","findParent(const DString& parentName, const Object* o)"); 
       throw e;
   }
   if( o -> getType() == parentName )
       return true;
    return ((o->_parentClasses).end() != (o->_parentClasses).find(parentName));
  }
  std::ostream& operator <<( std::ostream & os , const Object * o )
   //                   throw( NullPointerException *)
  {
   if( o == NULL){
       NullPointerException * e = new NullPointerException("Illegal Pointer ");
       e -> insert("Location","operator <<( std::ostream & os , const Object * o "); 
       throw e;
   }
    os <<  o->_toStringHeader() ;
    os <<  o->toString()        ;
    os <<  o->_toStringFooter() ;
    return os;
  }
  void          copyAddress( Object *&  left        , Object *& right )
   //                   throw( NullPointerException *)
  {
   if( right == NULL ){
       NullPointerException * e = new NullPointerException("Illegal Pointer ");
       e -> insert("Location","copyAddress( Object *&  left        , Object *& right)"); 
       throw e;
   }
    if( left != NULL)
     deleteObject(left);
    left = NULL;
    ((Object*)right)->_lock();
    ((Object*)right)->_referenceCount++;
    ((Object*)right)->_unLock();
    left = right;
  }
  void          deleteObject( Object *& o )
   //                   throw( NullPointerException *)
  {
   if( o == NULL){
       NullPointerException * e = new NullPointerException("Illegal Pointer ");
       e -> insert("Location","deleteObject(Object *& o )"); 
       throw e;
   }
    if( ((Object*)o)->_referenceCount > 1 )
    {
    ((Object*)o)->_lock();
    ((Object*)o)->_referenceCount--;
    ((Object*)o)->_unLock();
      return ;
    }
      delete o;
      o = NULL;
     // o == NULL ? std::cerr<<"NULL"<<std::endl : std::cerr<<"NotNULL"<<std::endl;
      return ;
  }
}
