/**
 * @file
 * @brief Class Object.
 *
 * ֥
 * @author  F.Fujiwara <daq-builder@zegenvs.ddo.jp>
 * @date 2004/1/23
 * @version 0.1
 */
#ifndef __DAQBuilderObject_HH__
#define __DAQBuilderObject_HH__
#define synchronized    _lock();
#define _synchronized   _unLock();
#include <DAQBuilderTypes.hh>
namespace DAQBuilder
{
  class SmartPointer;
  class Instance;
  class PrintStream;
  class Action;
  class Object
  {
   friend  class SmartPointer;
   friend  class Instance;
   friend  class PrintStream;
   friend  class Action;
  protected:
    pthread_mutex_t            _mutex;
    pthread_cond_t             _cond;
    pthread_attr_t             _attribute;
    std::set<DString>          _parentClasses;
    DString                    _type;
    DULong                     _referenceCount;
  protected:
    virtual  void              _finalize();
    virtual  void              _setType();
    virtual  void              _setParentClasses();
    virtual Object*            _clone() const;
    void                       _lock()   ;
    void                       _unLock()  ;
    void                       _tryLock() ;
    const DString              _toStringHeader() const ;
    const DString              _toStringFooter() const ;
  protected:
    void                       _upReferenceCount();
    void                       _downReferenceCount();
  public:
    virtual  const DULong&     getReferenceCount() const ;
    virtual  const DString&    getType() const ;
    virtual  DBool             equalTypes( const Object * o ) const ;
    virtual  const DString     toString() const ;
    virtual  void              notify();
    virtual  void              notifyAll();
    virtual  void              wait();
    virtual  void              wait(DULong secs, DULong nanoSecs = 0);
  public :
    Object();
    Object( const Object & _right );
    virtual ~Object();
  public:    
    virtual Object& operator   = (const Object & right );
    virtual DBool   operator   ==(const Object & right ) const ;
    virtual DBool   operator   !=(const Object & right ) const ;
    friend  DBool              findParent(const DString& parentName, const Object* o);
   //                   throw( NullPointerException *)
    friend   std::ostream& operator <<( std::ostream & os , const Object * o );
//                      throw( NullPointerException *);
    friend   void          copyAddress( Object *&          , Object *& o );
   //                   throw( NullPointerException *);
    friend   void          deleteObject( Object*&);
  //                   throw( NullPointerException *);
  };
  inline void   Object::_setParentClasses()
  {
    _parentClasses.clear();
  }
  inline void   Object::_setType()
  {
    this -> _type = "Object";
  }
  inline const  DString& Object::getType() const
  {
    return this -> _type;
  } 
  inline DBool Object::equalTypes( const Object * o ) const
  {
    return this -> _type == o -> getType() ;
  }
  inline void                       Object::_upReferenceCount()
  {
    //_lock();
    _referenceCount++;
    //_unLock();
  }
  inline  void                       Object::_downReferenceCount()
  {
    //_lock();
    _referenceCount--;
    //_unLock();
  }
}
#endif
