#ifndef __DAQBuilderSerializableObject_HH__
#define __DAQBuilderSerializableObject_HH__
#include <DAQBuilderTypes.hh>
#include <DAQBuilderObject.hh>
#include <Interface/DAQBuilderSerializable.hh>
#include <Interface/DAQBuilderPubliclyCloneable.hh>

namespace DAQBuilder 
{
  class SerializableObject : public Object , public Serializable , public PubliclyCloneable
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  public :
    SerializableObject();
    SerializableObject( const SerializableObject & _right );
    virtual ~SerializableObject();
  public:    
    virtual SerializableObject& operator   =(const SerializableObject & right );
    virtual DBool   operator   ==(const SerializableObject & right ) const ;
    virtual DBool   operator   !=(const SerializableObject & right ) const ;
  };
  inline void   SerializableObject::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
  }
  inline void   SerializableObject::_setType()
  {
    this -> _type = "SerializableObject";
  }
}
#endif
