#ifndef __DAQBuilderSerializeDataGettableObject_HH__
#define __DAQBuilderSerializeDataGettableObject_HH__
#include <DAQBuilderTypes.hh>
#include <DAQBuilderObject.hh>
#include <Interface/DAQBuilderSerializeDataGettable.hh>
#include <Interface/DAQBuilderPubliclyCloneable.hh>

namespace DAQBuilder 
{
  class SerializeDataGettableObject : public Object , public SerializeDataGettable 
  {
  protected:
    virtual  void              _setType();
    virtual  void              _setParentClasses();
  protected:
    DString                   _name;
  public :
    SerializeDataGettableObject();
    SerializeDataGettableObject( const SerializeDataGettableObject & _right );
    virtual ~SerializeDataGettableObject();
  public:    
    virtual SerializeDataGettableObject& operator   =(const SerializeDataGettableObject & right );
    virtual DBool   operator   ==(const SerializeDataGettableObject & right ) const ;
    virtual DBool   operator   !=(const SerializeDataGettableObject & right ) const ;
    const DString&         getName() const ;
    void                   setName( const DString& moduleName );
  };
  inline void   SerializeDataGettableObject::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("SerializeDataGettable");
  }
  inline void   SerializeDataGettableObject::_setType()
  {
    this -> _type = "SerializeDataGettableObject";
  }
  inline const DString&             SerializeDataGettableObject::getName() const 
  {
    return _name;
  }
  inline void                       SerializeDataGettableObject::setName( const DString& name )
  {
    _name = name;
  }
}
#endif
