#ifndef _DAQBuilderTypes_HH
#define _DAQBuilderTypes_HH
#include <DAQBuilderGlobals.hh>
namespace DAQBuilder
{
  /* Primitive Types */
  typedef int16_t                          DShort;
  typedef int32_t                          DInt;
  typedef int64_t                          DLong;
  typedef uint16_t                         DUShort;
  typedef uint32_t                         DUInt;
  typedef uint64_t                         DULong;
  typedef float                            DFloat;
  typedef double                           DDouble;
  typedef char                             DChar;
  typedef unsigned char                    DUChar;
  typedef uint8_t                          DByte;
  typedef bool                             DBool;
  typedef std::string                      DString;
  
  /* Type ID */
  typedef std::vector<DString>             StringList;
  class Instance;
  typedef std::vector<Instance>            Arguments;
  typedef std::vector<Instance>::iterator  ArgumentsIter;
  typedef std::map<DString,DString>        Properties;
  typedef std::map<DString,DString>        StackTrace;
  typedef std::vector<DByte>               ByteArray;
  typedef DInt                             FileDescriptor;

  /* Special Charactor */
  static const DChar          gSlash  =    '/';
  static const DChar          gStar   =    '*';
  static const DChar          gNewLine=    '\n';

  /* Primitive Type ID */
  enum ElementType
    {
      etShort,
      etInt,
      etLong,
      etUShort,
      etUInt,
      etULong,
      etFloat,
      etDouble,
      etChar,
      etUChar,
      etByte,
      etBool,
      etString,
      etSObject,
      etNumElementTypes,
      etUnknown = -1
    };
  enum CompareTypes
    {
      ctEquals,
      ctBig,
      ctSmall,
      ctNumCompareTypes,
      ctUnknown = -1
    };

  union PrimitiveValue
  {
    DShort  _shortValue;
    DInt    _intValue;
    DLong   _longValue;
    DUShort _ushortValue;
    DUInt   _uintValue;
    DULong  _ulongValue;
    DFloat  _floatValue;
    DDouble _doubleValue;
    DChar   _charValue;
    DUChar  _ucharValue;
    DByte   _byteValue;
    DBool   _boolValue;
  };
  
  struct SystemVMessageQueuePacket
  {
    long            _type;
    char            _data[10240];
  };
}
#endif
