#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderPrimitiveDataInputStream.hh>
namespace DAQBuilder
{
  DataElement::DataElement()
    :Number(),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DataElement& right )
    :Number(*((Number*)&right)),_elementName(right._elementName)
  {
    _setType();
    _setParentClasses();
  }
  
  DataElement::DataElement( const DShort&  i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DInt&    i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DLong&   i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DUShort& i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DUInt&   i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DULong&  i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DFloat&  i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DDouble& i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DChar&   i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DUChar&  i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const DBool&   i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement::DataElement( const Number&  i )
    :Number(i),_elementName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataElement&              DataElement::operator= ( const DataElement  & right )
  {
    *((Number*)this) =      *((Number*)&right);
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DShort& i )
  {
    _eType = etShort;
    _value._shortValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DInt& i )
  {
    _eType = etInt;
    _value._intValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DLong& i)
  {
    _eType = etLong;
    _value._longValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DUShort& i )
  {
    _eType = etUShort;
    _value._ushortValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DUInt& i )
  {
    _eType = etUInt;
    _value._uintValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DULong& i )
  {
    _eType = etULong;
    _value._ulongValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DFloat& i )
  {
    _eType = etFloat;
    _value._floatValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DDouble& i )
  {
    _eType = etDouble;
    _value._doubleValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DChar& i )
  {
    _eType = etChar;
    _value._charValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DUChar& i )
  {
    _eType = etUChar;
    _value._ucharValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const DBool& i )
  {
    _eType = etBool;
    _value._boolValue = i;
    _setType();
    _setParentClasses();
    return *this;
  }
  DataElement&              DataElement::operator= ( const Number& i )
  {
    *((Number*)this) = *((Number*)&i);
    _setType();
    _setParentClasses();
    return *this;
  }
  DShort  DataElement::getShort() const 
  {
    return _value._shortValue;
  }
  DInt    DataElement::getInt() const 
  {
    return _value._intValue;
  }
  DLong   DataElement::getLong() const
  {
    return _value._longValue;
  }
  DUShort DataElement::getUShort() const
  {
    return _value._ushortValue;
  }
  DUInt   DataElement::getUInt() const
  {
    return _value._uintValue;
  }
  DULong  DataElement::getULong() const
  {
    return _value._ulongValue;
  }
  DFloat  DataElement::getFloat() const
  {
    return _value._floatValue;
  }
  DDouble DataElement::getDouble() const
  {
    return _value._doubleValue;
  }
  DChar   DataElement::getChar() const
  {
    return _value._charValue;
  }
  DUChar  DataElement::getUChar() const
  {
    return _value._ucharValue;
  }
  DBool   DataElement::getBool() const
  {
    return _value._boolValue;
  }
  ByteArray                       DataElement::serialize()
  {
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_elementName);
    aPDO.writeShort((DShort)_eType);

    switch(_eType)
      { 
      case etShort:
        aPDO.writeShort( _value._shortValue);
	break;
      case etInt:
        aPDO.writeInt( _value._intValue);
	break;
      case etLong:
        aPDO.writeLong( _value._longValue);
	break;
      case etUShort:
        aPDO.writeUShort( _value._ushortValue);
	break;
      case etUInt:
        aPDO.writeUInt( _value._uintValue);
	break;
      case etULong:
        aPDO.writeULong( _value._ulongValue);
	break;
     case etFloat:
        aPDO.writeFloat( _value._floatValue);
	break;
      case etDouble:
        aPDO.writeDouble( _value._doubleValue);
	break;
      case etChar:
        aPDO.writeChar( _value._charValue);
	break;
      case etUChar:
      case etByte:
        aPDO.writeByte( _value._byteValue);
	break;
      case etBool:
        aPDO.writeBool( _value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aBAO.toByteArray();
  }
  void                       DataElement::serialize( DByte *& byteArray , DULong & byteArraySize )
  {
    ByteArrayOutputStream aBAO;
    PrimitiveDataOutputStream aPDO(&aBAO);
    aPDO.writeString(_elementName);
    aPDO.writeShort((DShort)_eType);

    switch(_eType)
      { 
      case etShort:
        aPDO.writeShort( _value._shortValue);
	break;
      case etInt:
        aPDO.writeInt( _value._intValue);
	break;
      case etLong:
        aPDO.writeLong( _value._longValue);
	break;
      case etUShort:
        aPDO.writeUShort( _value._ushortValue);
	break;
      case etUInt:
        aPDO.writeUInt( _value._uintValue);
	break;
      case etULong:
        aPDO.writeULong( _value._ulongValue);
	break;
     case etFloat:
        aPDO.writeFloat( _value._floatValue);
	break;
      case etDouble:
        aPDO.writeDouble( _value._doubleValue);
	break;
      case etChar:
        aPDO.writeChar( _value._charValue);
	break;
      case etUChar:
      case etByte:
        aPDO.writeByte( _value._byteValue);
	break;
      case etBool:
        aPDO.writeBool( _value._boolValue);
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    aBAO.toByteArray(byteArray,byteArraySize);
  }
  void                       DataElement::unSerialize( DByte * byteArray , const DULong& byteArraySize )
  {
    ByteArrayInputStream aBAI( byteArray,byteArraySize);
    PrimitiveDataInputStream aPDI(&aBAI);
    _elementName = aPDI.readString();
    _eType = (ElementType)aPDI.readShort();
    switch(_eType)
      { 
      case etShort:
      _value._shortValue = aPDI.readShort();
	break;
      case etInt:
      _value._intValue  = aPDI.readInt();
	break;
      case etLong:
      _value._longValue = aPDI.readLong();
	break;
      case etUShort:
      _value._ushortValue = aPDI.readUShort();
	break;
      case etUInt:
      _value._uintValue =  aPDI.readUInt();
	break;
      case etULong:
      _value._ulongValue = aPDI.readULong();
	break;
      case etFloat:
      _value._floatValue = aPDI.readFloat();
	break;
      case etDouble:
      _value._doubleValue = aPDI.readDouble();
	break;
      case etChar:
      _value._charValue = aPDI.readChar();
	break;
      case etUChar:
      case etByte:
      _value._byteValue = aPDI.readByte();
	break;
      case etBool:
      _value._boolValue = aPDI.readBool();
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    //std::cout<<"Type : "<<_eType<<std::endl;
  }
  Cloneable * DataElement::clone() const 
  {
    return (Cloneable*)new DataElement();
  }
  const DString DataElement::toString() const 
  {
    DString aString  = "Name  : ";
    aString         += _elementName;
    aString         += "\n";
    aString +="Type : ";
    switch(_eType)
      { 
      case etShort:
	aString +=" DShort\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong) _value._shortValue);
	break;
      case etInt:
	aString +=" DInt\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong)_value._intValue);
	break;
      case etLong:
	aString +=" DLong\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DLong)_value._longValue);
	break;
      case etUShort:
	aString +=" DUShort\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._ushortValue);
	break;
      case etUInt:
	aString +=" DUInt\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._uintValue);
	break;
      case etULong:
	aString +=" DULong\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DULong)_value._ulongValue);
	break;
      case etFloat:
	aString +=" DFloat\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DDouble)_value._floatValue);
	break;
      case etDouble:
	aString +=" DDouble\n";
	aString +="Vlaue: ";
        aString +=String::digitToString((DDouble)_value._doubleValue);
	break;
      case etChar:
	aString +=" DChar\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._charValue);
	break;
      case etUChar:
	aString +=" DUChar\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._ucharValue);
	break;
      case etByte:
	aString +=" DByte\n";
	aString +="Vlaue: ";
        aString.append((const char*)&_value._byteValue);
	break;
      case etBool:
	aString +=" DBool\n";
	aString +="Vlaue: ";
        _value._boolValue ? aString+=" true" :  aString+=" false" ;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aString;
  }
  const DString DataElement::_getValueString() const
  {
    DString aString;
    switch(_eType)
      { 
      case etShort:
        aString +=String::digitToString((DLong) _value._shortValue);
	break;
      case etInt:
        aString +=String::digitToString((DLong)_value._intValue);
	break;
      case etLong:
        aString +=String::digitToString((DLong)_value._longValue);
	break;
      case etUShort:
        aString +=String::digitToString((DULong)_value._ushortValue);
	break;
      case etUInt:
        aString +=String::digitToString((DULong)_value._uintValue);
	break;
      case etULong:
        aString +=String::digitToString((DULong)_value._ulongValue);
	break;
      case etFloat:
        aString +=String::digitToString((DDouble)_value._floatValue);
	break;
      case etDouble:
        aString +=String::digitToString((DDouble)_value._doubleValue);
	break;
      case etChar:
        aString.append((const char*)&_value._charValue);
	break;
      case etUChar:
        aString.append((const char*)&_value._ucharValue);
	break;
      case etByte:
        aString.append((const char*)&_value._byteValue);
	break;
      case etBool:
        _value._boolValue ? aString+=" true" :  aString+=" false" ;
	break;
      case etString:
      case etSObject:
      case etNumElementTypes:
      case etUnknown:
        break;
      }
    return aString;
  }
  DataElement::~DataElement()
  {
    _finalize();
  }
}
