#ifndef _DAQBuilderDataElement_HH
#define _DAQBuilderDataElement_HH
#include <Primitives/DAQBuilderNumber.hh>

namespace DAQBuilder
{
  class DataSegment;
  class DataElement : public Number
  {
   friend class DataSegment;
  private :
    void              _setType();
    void              _setParentClasses();
  public :
    virtual void                       serialize( DByte *& , DULong &  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  protected:
    DString                           _elementName;
    const DString                     _getValueString() const; 
  public :
    const DString toString() const ;
    DataElement();
    DataElement( const DataElement& );
    DataElement( const DShort&);
    DataElement( const DInt&);
    DataElement( const DLong&);
    DataElement( const DUShort&);
    DataElement( const DUInt&);
    DataElement( const DULong&);
    DataElement( const DFloat&);
    DataElement( const DDouble&);
    DataElement( const DChar&);
    DataElement( const DUChar&);
    DataElement( const DBool&);
    DataElement( const Number&);
    virtual ~DataElement();
  public:

    DataElement&              operator= ( const DataElement& );
    DataElement&              operator= ( const DShort&);
    DataElement&              operator= ( const DInt&);
    DataElement&              operator= ( const DLong&);
    DataElement&              operator= ( const DUShort&);
    DataElement&              operator= ( const DUInt&);
    DataElement&              operator= ( const DULong&);
    DataElement&              operator= ( const DFloat&);
    DataElement&              operator= ( const DDouble&);
    DataElement&              operator= ( const DChar&);
    DataElement&              operator= ( const DUChar&);
    DataElement&              operator= ( const DBool&);
    DataElement&              operator= ( const Number&);

    DShort  getShort() const ;
    DInt    getInt() const ;
    DLong   getLong() const;
    DUShort getUShort() const;
    DUInt   getUInt() const;
    DULong  getULong() const;
    DFloat  getFloat() const;
    DDouble getDouble() const;
    DChar   getChar() const;
    DUChar  getUChar() const;
    DBool   getBool() const;

    const DString&        getElementName() const ;
    void                  setElementName(const DString& _elementName );
  };
  inline void              DataElement::_setType()
  {
    _type="DataElement";
  }
  inline void              DataElement::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
    _parentClasses.insert("Number");
  }
  inline   const DString&        DataElement::getElementName() const 
  {
    return _elementName;
  }
  inline void                  DataElement::setElementName(const DString& elementName )
  {
    _elementName = elementName ;
  }
}
#endif
