#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSystem.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void DataRecord::_finalize()
  {
    clear();
  }
  DataRecord::DataRecord()
    :std::map<DLong,DataSection>(),SerializableObject()
  {
    _setType();
    _setParentClasses();
  }
  DataRecord::DataRecord( const DataRecord& right)
    :std::map<DLong,DataSection>(*((std::map<DLong,DataSection>*)&right)),SerializableObject(*((SerializableObject*)&right)),_comment(right._comment)
  {
    ;
  }
  const DString DataRecord::toString() const 
  {
    DString returnString;
    returnString += "Comment";
    returnString += _comment;
    returnString += "\n";
    returnString += "{";
    returnString += "\n";
    for( std::map<DLong,DataSection>::const_iterator iter = begin();
                                                      iter!= end(); 
                                                      iter++)
      {	
	returnString+="( ";
	returnString+= String::digitToString(iter->first); 
	returnString+=" , ";
	returnString+=  ((DataSection)(iter->second))._getValueString();
	returnString+=" )";
	returnString += "\n";
      }
    returnString += "}\n";
    return returnString;
  }
  DataRecord::~DataRecord()
  {
    _finalize();
  }
  DBool  DataRecord::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
         return false;
    return equals(*((DataRecord*)o));
  }
  DBool  DataRecord::equals( const DataRecord& o ) const 
  {
    if(size() != o.size())
      return false;
    DBool aBool= _comment == o._comment;
    std::map<DLong,DataSection>::const_iterator iter  = begin(); 
    std::map<DLong,DataSection>::const_iterator iterO = o.begin(); 
    for( ; iter != end() ;iter++)
    {
        aBool |= (iter->second).equals((iterO->second));
    }
    return aBool;
  }
  DataRecord&              DataRecord::operator= ( const DataRecord  & right )
  {
     *((Object*)this)           = *((Object*)&right); 
     *((std::map<DLong,DataSection>*)this) = *((std::map<DLong,DataSection>*)&right); 
      _comment = right._comment;
     return *this;
   }
  void                  DataRecord::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    aOOS.writeString(_comment);
    for(  std::map<DLong,DataSection>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeULong(iter->first);
	aOOS.writeObject((SerializableObject&)(iter->second));
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  DataRecord::serialize()
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    aOOS.writeString(_comment);
    for(  std::map<DLong,DataSection>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeULong(iter->first);
	aOOS.writeObject((SerializableObject&)(iter->second));
      }
    return aBAO.toByteArray();
  }
  void                  DataRecord::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    ObjectInputStream        aOIS(&aBAI);
    _comment =               aOIS.readString();
    clear();
    while(aBAI.available()!=0)
      {
        DULong      aFirst  = aOIS.readULong();
        DataSection aSecond = *((DataSection*)aOIS.readObject());
        aSecond.setSectionName( aFirst );
	insert(std::pair<DULong,DataSection>(aFirst,aSecond));
      }
  }
  Cloneable *                DataRecord::clone() const 
  {
    return (Cloneable*)new DataRecord(*this);
  }

  /*void                  DataRecord::insertPair( const DString& first , const DataSection& second )
      throw (SameNameBindedException *)
  {
    std::map<DString,DataSection>::const_iterator iter = find(first);
    if(iter != end())
      throw new SameNameBindedException("DataRecord::insertPair(const DString& , const DataSection& second ) "+first);
    insert(std::pair<DString,DataSection>(first,second));
  }*/
  void                  DataRecord::insertData( const DataSection& second )
      throw (SameNameBindedException *)
  {
    std::map<DLong,DataSection>::const_iterator iter = find( second.getSectionName() );
    if(iter != end())
      throw new SameNameBindedException("DataSection::insert(const DataSegment& second ) "+String::digitToString(second.getSectionName()));
    insert(std::pair<DULong,DataSection>(second.getSectionName(),second));
  }

  const DataSection&    DataRecord::search( const DString& first ) const 
      throw (Exception *)
  {
    std::map<DLong,DataSection>::const_iterator iter = find((DLong)atoll(first.c_str()));
    if(iter == end())
      throw new Exception("DataSection::seach(const DString)"+first);
    else
      return iter->second;
  }
    const DString&        DataRecord::getComment() const
    {
       return _comment;
    }
    void                  DataRecord::setComment( const DString& comment )
    {
      _comment = comment;
    }
  void                  DataRecord::dump( const DString& first ) const 
    throw( Exception * )
  {
    if( first == "all" )
      {
	System::out.println( toString() );
        return ;
      }
    DBool isLeaf = 
      (first.end() == std::find(first.begin(),first.end(),'.'));
    if(isLeaf)
      {
	System::out.println( search(first) );
      }
    else
      {
        const DString branchName = first.substr(0,first.find('.'));
        const DString branchArgs = first.substr(first.find('.')+1,first.length()); 
        search(branchName).dump(branchArgs);
      }
  }
}
