#ifndef _DAQBuilderDataRecord_HH
#define _DAQBuilderDataRecord_HH
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  class DataSection;
  class DataRecord : public std::map<DLong,DataSection> , public SerializableObject
  {
  private :
    void              _finalize();
    void              _setType();
    void              _setParentClasses();
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  protected:
    const DString                      _getValueString() const; 
    DString                            _comment;
  public :
    const DString toString() const ;
    DataRecord();
    DataRecord( const DataRecord& );
    virtual ~DataRecord();
  public:
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const DataRecord& o ) const ;
    DataRecord&              operator= ( const DataRecord  & right );
  public:
    //void                  insertPair( const DString& first , const DataSection& second )
    void                  insertData( const DataSection& second )
      throw (SameNameBindedException *);

    const DataSection&    search( const DString& first ) const 
      throw (Exception *);

    const DString&        getComment() const;
    void                  setComment( const DString& _comment );
   
    virtual void                  dump( const DString& first ) const 
      throw( Exception * );
  };

  inline void              DataRecord::_setType()
  {
    this -> _type="DataRecord";
  }
  inline void              DataRecord::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
}
#endif
