#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSystem.hh>
#include <Primitives/DAQBuilderString.hh>
namespace DAQBuilder
{
  void DataSection::_finalize()
  {
    clear();
  }
  DataSection::DataSection()
    :std::map<DString,DataSegment>(),SerializableObject(),_sectionName(-1)
  {
    _setType();
    _setParentClasses();
  }
  DataSection::DataSection( const DataSection& right)
    :std::map<DString,DataSegment>((std::map<DString,DataSegment>)right),SerializableObject(*((SerializableObject*)&right)),_sectionName(right._sectionName)
  {
    ;
  }
  const DString DataSection::toString() const 
  {
    DString returnString="Name  : ";
    returnString += String::digitToString(_sectionName);
    returnString += "\n";
    returnString += _getValueString();
    return returnString;
  }
  const DString DataSection::_getValueString() const 
  {
    DString returnString;
    returnString += "{";
    returnString += "\n";
    for(std::map<DString,DataSegment>::const_iterator piter = begin();
	piter != end() ; 
	piter ++)
      {	
	returnString+="( ";
	returnString+= piter->first;
	returnString+=" , ";
	returnString+=  ((DataSegment)piter->second)._getValueString();
	returnString+=" )";
	returnString += "\n";
      }
    returnString += "}\n";
    return returnString;
  }
  DataSection::~DataSection()
  {
    _finalize();
  }
  DBool  DataSection::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
         return false;
    return equals(*((DataSection*)o));
  }
  DBool  DataSection::equals( const DataSection& o ) const 
  {
    if(size() != o.size())
      return false;
    DBool aBool=false;
    std::map<DString,DataSegment>::const_iterator iter  = begin(); 
    std::map<DString,DataSegment>::const_iterator iterO = o.begin(); 
    for( ; iter != end() ;iter++)
    {
        aBool |= (iter->second).equals((iterO->second));
    }
    return aBool;
  }
  DataSection&              DataSection::operator= ( const DataSection  & right )
  {
     *((Object*)this)           = *((Object*)&right); 
     *((std::map<DString,DataSegment>*)this) = *((std::map<DString,DataSegment>*)&right); 
     return *this;
   }
  void                  DataSection::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    aOOS.writeLong(_sectionName);
    for(  std::map<DString,DataSegment>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeString(iter->first);
	aOOS.writeObject((SerializableObject&)iter->second);
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  DataSection::serialize()
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aOOS(&aBAO);
    aOOS.writeLong(_sectionName);
    for(  std::map<DString,DataSegment>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aOOS.writeString(iter->first);
	aOOS.writeObject((SerializableObject&)iter->second);
      }
    return aBAO.toByteArray();
  }
  void                  DataSection::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    ObjectInputStream        aOIS(&aBAI);
    _sectionName =           aOIS.readLong();
    clear();
    while(aBAI.available()!=0)
      {
        DString     aFirst=aOIS.readString();
        DataSegment aSecond = *((DataSegment*)aOIS.readObject());
        aSecond.setSegmentName(aFirst);
	insert(std::pair<DString,DataSegment>(aFirst,aSecond));
      }
  }
  Cloneable *                DataSection::clone() const 
  {
    return (Cloneable*)new DataSection(*this);
  }

  /*  void                  DataSection::insertPair( const DString& first , const DataSegment& second )
      throw (SameNameBindedException *)
  {
    std::map<DString,DataSegment>::const_iterator iter = find(first);
    if(iter != end())
      throw new SameNameBindedException("DataSection::insertPair(const DString& , const DataSegment& second ) "+first);
    insert(std::pair<DString,DataSegment>(first,second));
    }*/
  void                  DataSection::insertData( const DataSegment& second )
      throw (SameNameBindedException *)
  {
    std::map<DString,DataSegment>::const_iterator iter = find(second.getSegmentName());
    if(iter != end())
      throw new SameNameBindedException("DataSection::insert(const DataSegment& second ) "+second.getSegmentName());
    insert(std::pair<DString,DataSegment>(second.getSegmentName(),second));
  }

  const DataSegment&    DataSection::search( const DString& first ) const 
      throw (Exception *)
  {
    std::map<DString,DataSegment>::const_iterator iter = find(first);
    if(iter == end())
      throw new Exception("DataSection::seach(const DString)"+first);
    else
      return iter->second;
  }
  void                  DataSection::dump( const DString& first ) const 
    throw( Exception * )
  {
    DBool isLeaf = 
      (first.end() == std::find(first.begin(),first.end(),'.'));
    if(isLeaf)
      {
	System::out.println( search(first) );
      }
    else
      {
        const DString branchName = first.substr(0,first.find('.'));
        const DString branchArgs = first.substr(first.find('.')+1,first.length()); 
        search(branchName).dump(branchArgs);
      }
  }

}
