#ifndef _DAQBuilderDataSection_HH
#define _DAQBuilderDataSection_HH
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  class DataRecord;
  class DataSegment;
  class DataSection : public std::map<DString,DataSegment> , public SerializableObject
  {
   friend class DataRecord;
  private :
    void              _finalize();
    void              _setType();
    void              _setParentClasses();
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  protected:
    DLong                              _sectionName;
    const DString                      _getValueString() const; 
  public :
    const DString toString() const ;
    DataSection();
    DataSection( const DataSection& );
    virtual ~DataSection();
  public:
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const DataSection& o ) const ;
    DataSection&              operator= ( const DataSection  & right );
  public:
    //    void                  insertPair( const DString& first , const DataSegment& second )
    void                  insertData( const DataSegment& second )
      throw (SameNameBindedException *);

    const DataSegment&    search( const DString& first ) const 
      throw (Exception *);

    const DLong&          getSectionName() const ;
    void                  setSectionName(const DLong& _sectionName );
    virtual void                  dump( const DString& first ) const 
      throw( Exception * );
  };

  inline void              DataSection::_setType()
  {
    this -> _type="DataSection";
  }
  inline void              DataSection::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
  inline   const DLong&        DataSection::getSectionName() const 
  {
    return _sectionName;
  }
  inline void                  DataSection::setSectionName(const DLong& sectionName )
  {
    _sectionName = sectionName ;
  }
}
#endif
