#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Primitives/DAQBuilderString.hh>
#include <System/IO/DAQBuilderByteArrayOutputStream.hh>
#include <System/IO/DAQBuilderObjectOutputStream.hh>
#include <System/IO/DAQBuilderByteArrayInputStream.hh>
#include <System/IO/DAQBuilderObjectInputStream.hh>
#include <System/DAQBuilderSystem.hh>
namespace DAQBuilder
{
  void DataSegment::_finalize()
  {
    clear();
  }
  DataSegment::DataSegment()
    :std::map<DString,DataElement>(),SerializableObject(),_segmentName("NoName")
  {
    _setType();
    _setParentClasses();
  }
  DataSegment::DataSegment( const DataSegment& right)
    :std::map<DString,DataElement>((std::map<DString,DataElement>)right),SerializableObject(*((SerializableObject*)&right)),_segmentName(right._segmentName)
  {
    ;
  }
  const DString DataSegment::_getValueString() const 
  {
    DString returnString;
    returnString += "{";
    returnString += "\n";
    for(std::map<DString,DataElement>::const_iterator piter = begin();
	piter != end() ; 
	piter ++)
      {	
	returnString+="( ";
	returnString+= piter->first;
	returnString+=" , ";
	returnString+= (piter->second)._getValueString();
	returnString+=" )";
	returnString += "\n";
      }
    returnString += "}\n";
    return returnString;
  }
  const DString DataSegment::toString() const 
  {
    DString returnString="Name  : ";
    returnString += _segmentName;
    returnString += "\n";
    returnString += _getValueString();
    return returnString;
  }

  DataSegment::~DataSegment()
  {
    _finalize();
  }
  DBool  DataSegment::equals( const Object * o ) const 
  {
    if(!findParent(_type,o))
         return false;
    return equals(*((DataSegment*)o));
  }
  DBool  DataSegment::equals( const DataSegment& o ) const 
  {
    if(size() != o.size())
      return false;
    DBool aBool=false;
    std::map<DString,DataElement>::const_iterator iter  = begin(); 
    std::map<DString,DataElement>::const_iterator iterO = o.begin(); 
    for( ; iter != end() ;iter++)
    {
        aBool |= (iter->second).equals((iterO->second));
    }
    return aBool;
  }
  DataSegment&              DataSegment::operator= ( const DataSegment  & right )
  {
     *((Object*)this)           = *((Object*)&right); 
     *((std::map<DString,DataElement>*)this) = *((std::map<DString,DataElement>*)&right); 
     return *this;
   }
  void                  DataSegment::serialize( DByte *& data , DULong& dataSize )
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aPDO(&aBAO);
    aPDO.writeString(_segmentName);
    for(  std::map<DString,DataElement>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aPDO.writeString(iter->first);
	aPDO.writeObject((SerializableObject&)iter->second);
      }
    return aBAO.toByteArray(data,dataSize);
  }
  ByteArray                  DataSegment::serialize()
  {
    ByteArrayOutputStream aBAO;   
    ObjectOutputStream aPDO(&aBAO);
    aPDO.writeString(_segmentName);
    for(  std::map<DString,DataElement>::const_iterator iter = begin();
	  iter != end();
	  iter++)
      {
	aPDO.writeString(iter->first);
	aPDO.writeObject((SerializableObject&)iter->second);
      }
    return aBAO.toByteArray();
  }
  void                  DataSegment::unSerialize( DByte * data , const DULong & dataSize )
  {
    ByteArrayInputStream     aBAI(data,dataSize);   
    ObjectInputStream        aPDI(&aBAI);
    _segmentName = aPDI.readString();
    clear();
    while(aBAI.available()!=0)
      { 
	DString     aFirst=aPDI.readString();
        DataElement aSecond = *((DataElement*)aPDI.readObject());
        aSecond.setElementName(aFirst);
	insert(std::pair<DString,DataElement>(aFirst,aSecond));
      }
  }
  Cloneable *                DataSegment::clone() const 
  {
    return (Cloneable*)new DataSegment(*this);
  }

  /*void                  DataSegment::insertPair( const DString& first , const DataElement& second )
      throw (SameNameBindedException *)
  {
    std::map<DString,DataElement>::const_iterator iter = find(first);
    if(iter != end())
      throw new SameNameBindedException("DataSegment::insertPair(const DString& , const DataElement& second ) "+first);
    insert(std::pair<DString,DataElement>(first,second));
    }*/
  void                  DataSegment::insertData( const DataElement& second )
      throw (SameNameBindedException *)
  {    std::map<DString,DataElement>::const_iterator iter = find(second.getElementName());
    if(iter != end())
      throw new SameNameBindedException("DataSegment::insert(const DataElement& second ) "+second.getElementName());
    insert(std::pair<DString,DataElement>(second.getElementName(),second));
  }

  const DataElement&    DataSegment::search( const DString& first ) const 
      throw (Exception *)
  {
    std::map<DString,DataElement>::const_iterator iter = find(first);
    if(iter == end())
      throw new Exception("DataSegment::seach(const DString)"+first);
    else
      return iter->second;
  }

  void                  DataSegment::dump( const DString& first ) const 
    throw( Exception * )
  {
    System::out.println( search(first) );
  }

}
