#ifndef _DAQBuilderDataSegment_HH
#define _DAQBuilderDataSegment_HH
#include <Exception/DAQBuilderSameNameBindedException.hh>
#include <DAQBuilderSerializableObject.hh>

namespace DAQBuilder
{
  class DataSection;
  class DataElement;
  class DataSegment : public std::map<DString,DataElement> , public SerializableObject
  {
   friend class DataSection;
  private :
    void              _finalize();
    void              _setType();
    void              _setParentClasses();
  public :
    virtual void                       serialize(   DByte *& ,       DULong&  );
    virtual ByteArray                  serialize();
    virtual void                       unSerialize( DByte *  , const DULong&  );
    virtual Cloneable *                clone() const ;
  protected:
    DString                           _segmentName;
    const DString                      _getValueString() const; 
  public :
    const DString toString() const ;
    DataSegment();
    DataSegment( const DataSegment& );
    virtual ~DataSegment();
  public:
    virtual DBool  equals( const Object * o ) const ;
    virtual DBool  equals( const DataSegment& o ) const ;
    DataSegment&              operator= ( const DataSegment  & right );
  public:
    //    void                  insertPair( const DString& first , const DataElement& second )
    void                  insertData( const DataElement& second )
      throw (SameNameBindedException *);

    const DataElement&    search( const DString& first ) const 
      throw (Exception *);
    const DString&        getSegmentName() const ;
    void                  setSegmentName(const DString& _segmentName );
    virtual void                  dump( const DString& first ) const 
      throw( Exception * );
  };

  inline void              DataSegment::_setType()
  {
    this -> _type="DataSegment";
  }
  inline void              DataSegment::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("PubliclyCloneable");
    _parentClasses.insert("Serializable");
    _parentClasses.insert("SerializableObject");
  }
  inline   const DString&        DataSegment::getSegmentName() const 
  {
    return _segmentName;
  }
  inline void                  DataSegment::setSegmentName(const DString& segmentName )
  {
    _segmentName = segmentName ;
  }
}
#endif
