#ifndef _DAQBuilderActionNotFoundException_HH
#define _DAQBuilderActionNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ActionNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ActionNotFoundException();
    ActionNotFoundException( const std::string &          _message );
    ActionNotFoundException( const ActionNotFoundException & _right );
    virtual ~ActionNotFoundException();
  };
  
  inline  void ActionNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ActionNotFoundException::_setType()
  {
    this -> _type = "ActionNotFoundException";
  }
  inline   ActionNotFoundException::ActionNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ActionNotFoundException::ActionNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ActionNotFoundException::ActionNotFoundException( const ActionNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ActionNotFoundException::~ActionNotFoundException()
  {
    _finalize();
  }
}
#endif
