#ifndef _DAQBuilderArithmeticException_HH
#define _DAQBuilderArithmeticException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ArithmeticException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ArithmeticException();
    ArithmeticException( const std::string &          _message );
    ArithmeticException( const ArithmeticException & _right );
    virtual ~ArithmeticException();
  };
  
  inline  void ArithmeticException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ArithmeticException::_setType()
  {
    this -> _type = "ArithmeticException";
  }
  inline   ArithmeticException::ArithmeticException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ArithmeticException::ArithmeticException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ArithmeticException::ArithmeticException( const ArithmeticException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ArithmeticException::~ArithmeticException()
  {
    _finalize();
  }
}
#endif
