#ifndef _DAQBuilderModuleModuleException_HH
#define _DAQBuilderModuleModuleException_HH
#include <Exception/DAQBuilderModuleException.hh>

namespace DAQBuilder
{
  class CAMACModuleException : public ModuleException
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    CAMACModuleException();
    CAMACModuleException( const DString &          _message );
    CAMACModuleException( const DString &          location , const DString& message);
    CAMACModuleException( const CAMACModuleException & _right );
    virtual ~CAMACModuleException();
  };
  
  inline  void CAMACModuleException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("ModuleException");
	  _parentClasses.insert("ModuleException");
  }
  inline void  CAMACModuleException::_setType()
  {
    this -> _type = "CAMACModuleException";
  }
  inline   CAMACModuleException::CAMACModuleException()
    :ModuleException()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CAMACModuleException::CAMACModuleException( const DString & _message )
    :ModuleException( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CAMACModuleException::CAMACModuleException( const DString& location , const DString & _message )
    :ModuleException( _message )
  {
    this->_setType();
    this->_setParentClasses();
    insert("Loation",location); 
  }
  inline   CAMACModuleException::CAMACModuleException( const CAMACModuleException & rhs )
    :ModuleException( *((ModuleException*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CAMACModuleException::~CAMACModuleException()
  {
    _finalize();
  }
}
#endif
