#ifndef _DAQBuilderClassNotFoundException_HH
#define _DAQBuilderClassNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ClassNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ClassNotFoundException();
    ClassNotFoundException( const std::string &          _message );
    ClassNotFoundException( const ClassNotFoundException & _right );
    virtual ~ClassNotFoundException();
  };
  
  inline  void ClassNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ClassNotFoundException::_setType()
  {
    this -> _type = "ClassNotFoundException";
  }
  inline   ClassNotFoundException::ClassNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ClassNotFoundException::ClassNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ClassNotFoundException::ClassNotFoundException( const ClassNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ClassNotFoundException::~ClassNotFoundException()
  {
    _finalize();
  }
}
#endif
