#ifndef _DAQBuilderCommandException_HH
#define _DAQBuilderCommandException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class CommandException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    CommandException();
    CommandException( const std::string &          _message );
    CommandException( const CommandException & _right );
    virtual ~CommandException();
  };
  
  inline  void CommandException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  CommandException::_setType()
  {
    this -> _type = "CommandException";
  }
  inline   CommandException::CommandException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandException::CommandException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandException::CommandException( const CommandException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandException::~CommandException()
  {
    _finalize();
  }
}
#endif
