#ifndef _DAQBuilderCommandNotFoundException_HH
#define _DAQBuilderCommandNotFoundException_HH
#include <Exception/DAQBuilderCommandException.hh>

namespace DAQBuilder
{
  class CommandNotFoundException : public CommandException
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    CommandNotFoundException();
    CommandNotFoundException( const std::string &          _message );
    CommandNotFoundException( const CommandNotFoundException & _right );
    virtual ~CommandNotFoundException();
  };
  
  inline  void CommandNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  CommandNotFoundException::_setType()
  {
    this -> _type = "CommandNotFoundException";
  }
  inline   CommandNotFoundException::CommandNotFoundException()
    :CommandException()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandNotFoundException::CommandNotFoundException( const std::string & _message )
    :CommandException( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandNotFoundException::CommandNotFoundException( const CommandNotFoundException & rhs )
    :CommandException( *((CommandException*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   CommandNotFoundException::~CommandNotFoundException()
  {
    _finalize();
  }
}
#endif
