#ifndef _DAQBuilderDeflationException_HH
#define _DAQBuilderDeflationException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class DeflationException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    DeflationException();
    DeflationException( const std::string &          _message );
    DeflationException( const DeflationException & _right );
    virtual ~DeflationException();
  };
  
  inline  void DeflationException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  DeflationException::_setType()
  {
    this -> _type = "DeflationException";
  }
  inline   DeflationException::DeflationException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DeflationException::DeflationException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DeflationException::DeflationException( const DeflationException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DeflationException::~DeflationException()
  {
    _finalize();
  }
}
#endif
