#ifndef _DAQBuilderDisagreementOfTypeException_HH
#define _DAQBuilderDisagreementOfTypeException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class DisagreementOfTypeException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    DisagreementOfTypeException();
    DisagreementOfTypeException( const std::string &          _message );
    DisagreementOfTypeException( const DisagreementOfTypeException & _right );
    virtual ~DisagreementOfTypeException();
  };
  
  inline  void DisagreementOfTypeException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  DisagreementOfTypeException::_setType()
  {
    this -> _type = "DisagreementOfTypeException";
  }
  inline   DisagreementOfTypeException::DisagreementOfTypeException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DisagreementOfTypeException::DisagreementOfTypeException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DisagreementOfTypeException::DisagreementOfTypeException( const DisagreementOfTypeException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   DisagreementOfTypeException::~DisagreementOfTypeException()
  {
    _finalize();
  }
}
#endif
