#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
    void Exception::_finalize()
    {
      _stackTrace.clear();
    }
    const DString             Exception::toString() const 
    {
      DString aString ;//= _toStringHeader();
      for( StackTrace::const_iterator iter = _stackTrace.begin();
	 iter != _stackTrace.end(); 
	 iter++)
      {
	aString += iter -> first;
	aString += " : ";
        aString += iter -> second;
	aString += "\n";
      }
      //aString += _toStringFooter();
      return aString;
    }
    void  Exception::insert( const DString&  key , const DString& value )
    {
      StackTrace::iterator iter = _stackTrace.find( key );
      if( iter==_stackTrace.end())
	{
	  _stackTrace.insert( std::pair<DString,DString>(key , value ));
	} 
    }
    void  Exception::remove( const DString&  key )
    {
      StackTrace::iterator iter = _stackTrace.find( key );
      if( iter!=_stackTrace.end())
	{
	  _stackTrace.erase(iter);
	} 
    }
    const DString  Exception::find( const DString& key ) const
    {
      StackTrace::const_iterator iter = _stackTrace.find( key );
      DString aString="";
      if( iter!=_stackTrace.end())
	{
          aString += iter->second;
	}  
      return aString;
    }
  DBool   Exception::operator   ==(const Exception & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    return aBool;
  }
  DBool   Exception::operator   !=(const Exception & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    return aBool;
  }
}
