#ifndef _DAQBuilderException_HH
#define _DAQBuilderException_HH
#include <Interface/DAQBuilderThrowable.hh>
#include <DAQBuilderObject.hh>

namespace DAQBuilder
{
  class Exception : public Object , public Throwable
  {
  protected:
    StackTrace                _stackTrace;
  protected:
    virtual void              _setType();
    virtual void              _finalize();
    virtual void              _setParentClasses();
  public :
    Exception();
    Exception( const DString   &   _message );
    Exception( const Exception &   _right );
    virtual ~Exception();
    Exception& operator   =(const Exception & right );
    virtual DBool   operator   ==(const Exception & right ) const ;
    virtual DBool   operator   !=(const Exception & right ) const ;
  public :
    const DString             toString() const ;
    void  insert( const DString&  key , const DString& value );
    void  remove( const DString&  key );
    const DString  find( const DString& key ) const; 
  };
  inline void Exception::_setType()
  {
    this -> _type = "Exception";
  }
  inline  void Exception::_setParentClasses()
  {
    _parentClasses.insert("Object");
    _parentClasses.insert("Throwable");
  }
  inline  Exception::Exception()
    :Throwable()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline  Exception::Exception( const DString & _message )
    :Throwable()
  {
    this->_setType();
    this->_setParentClasses();
    _stackTrace.insert( std::pair<DString,DString>("Message",_message));
  }
  inline  Exception::Exception( const Exception & right )
    :Throwable(*((Throwable*)&right))
  {
    this->_setType();
    this->_setParentClasses();
    
    this->_stackTrace.clear();
    this->_stackTrace = right._stackTrace;
  }
  inline  Exception::~Exception()
  {
    _finalize();
  }
  inline Exception& Exception::operator   =(const Exception & right )
  {
    *((Object*)this) = *((Object*)&right);
    this->_stackTrace.clear();
    this->_stackTrace = right._stackTrace;
    return *this;
  }
}
#endif
