#ifndef _DAQBuilderFieldNotFoundException_HH
#define _DAQBuilderFieldNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class FieldNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    FieldNotFoundException();
    FieldNotFoundException( const std::string &          _message );
    FieldNotFoundException( const FieldNotFoundException & _right );
    virtual ~FieldNotFoundException();
  };
  
  inline  void FieldNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  FieldNotFoundException::_setType()
  {
    this -> _type = "FieldNotFoundException";
  }
  inline   FieldNotFoundException::FieldNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FieldNotFoundException::FieldNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FieldNotFoundException::FieldNotFoundException( const FieldNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FieldNotFoundException::~FieldNotFoundException()
  {
    _finalize();
  }
}
#endif
