#ifndef _DAQBuilderFileNotFoundException_HH
#define _DAQBuilderFileNotFoundException_HH
#include <Exception/DAQBuilderIOException.hh>

namespace DAQBuilder
{
  class FileNotFoundException : public IOException
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    FileNotFoundException();
    FileNotFoundException( const std::string &          _message );
    FileNotFoundException( const FileNotFoundException & _right );
    virtual ~FileNotFoundException();
  };
  
  inline  void FileNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  FileNotFoundException::_setType()
  {
    this -> _type = "FileNotFoundException";
  }
  inline   FileNotFoundException::FileNotFoundException()
    :IOException()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FileNotFoundException::FileNotFoundException( const std::string & _message )
    :IOException( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FileNotFoundException::FileNotFoundException( const FileNotFoundException & rhs )
    :IOException( *((IOException*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   FileNotFoundException::~FileNotFoundException()
  {
    _finalize();
  }
}
#endif
