#ifndef _DAQBuilderIOException_HH
#define _DAQBuilderIOException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class IOException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    IOException();
    IOException( const std::string &          _message );
    IOException( const IOException & _right );
    virtual ~IOException();
  };
  
  inline  void IOException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  IOException::_setType()
  {
    this -> _type = "IOException";
  }
  inline   IOException::IOException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IOException::IOException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IOException::IOException( const IOException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IOException::~IOException()
  {
    _finalize();
  }
}
#endif
