#ifndef _DAQBuilderIllegalArgumentException_HH
#define _DAQBuilderIllegalArgumentException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class IllegalArgumentException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    IllegalArgumentException();
    IllegalArgumentException( const std::string &          _message );
    IllegalArgumentException( const IllegalArgumentException & _right );
    virtual ~IllegalArgumentException();
  };
  
  inline  void IllegalArgumentException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  IllegalArgumentException::_setType()
  {
    this -> _type = "IllegalArgumentException";
  }
  inline   IllegalArgumentException::IllegalArgumentException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IllegalArgumentException::IllegalArgumentException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IllegalArgumentException::IllegalArgumentException( const IllegalArgumentException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   IllegalArgumentException::~IllegalArgumentException()
  {
    _finalize();
  }
}
#endif
