#ifndef _DAQBuilderInflationException_HH
#define _DAQBuilderInflationException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class InflationException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    InflationException();
    InflationException( const std::string &          _message );
    InflationException( const InflationException & _right );
    virtual ~InflationException();
  };
  
  inline  void InflationException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  InflationException::_setType()
  {
    this -> _type = "InflationException";
  }
  inline   InflationException::InflationException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   InflationException::InflationException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   InflationException::InflationException( const InflationException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   InflationException::~InflationException()
  {
    _finalize();
  }
}
#endif
