#ifndef _DAQBuilderMethodNotFoundException_HH
#define _DAQBuilderMethodNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class MethodNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    MethodNotFoundException();
    MethodNotFoundException( const std::string &          _message );
    MethodNotFoundException( const MethodNotFoundException & _right );
    virtual ~MethodNotFoundException();
  };
  
  inline  void MethodNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  MethodNotFoundException::_setType()
  {
    this -> _type = "MethodNotFoundException";
  }
  inline   MethodNotFoundException::MethodNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   MethodNotFoundException::MethodNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   MethodNotFoundException::MethodNotFoundException( const MethodNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   MethodNotFoundException::~MethodNotFoundException()
  {
    _finalize();
  }
}
#endif
