#ifndef _DAQBuilderModuleException_HH
#define _DAQBuilderModuleException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ModuleException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ModuleException();
    ModuleException( const std::string &          _message );
    ModuleException( const ModuleException & _right );
    virtual ~ModuleException();
  };
  
  inline  void ModuleException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
	  _parentClasses.insert("Exception");
  }
  inline void  ModuleException::_setType()
  {
    this -> _type = "ModuleException";
  }
  inline   ModuleException::ModuleException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ModuleException::ModuleException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ModuleException::ModuleException( const ModuleException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ModuleException::~ModuleException()
  {
    _finalize();
  }
}
#endif
