#ifndef _DAQBuilderNullPointerException_HH
#define _DAQBuilderNullPointerException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class NullPointerException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    NullPointerException();
    NullPointerException( const std::string &          _message );
    NullPointerException( const NullPointerException & _right );
    virtual ~NullPointerException();
  };
  
  inline  void NullPointerException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  NullPointerException::_setType()
  {
    this -> _type = "NullPointerException";
  }
  inline   NullPointerException::NullPointerException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   NullPointerException::NullPointerException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   NullPointerException::NullPointerException( const NullPointerException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   NullPointerException::~NullPointerException()
  {
    _finalize();
  }
}
#endif
