#ifndef _DAQBuilderObjectNotFoundException_HH
#define _DAQBuilderObjectNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ObjectNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ObjectNotFoundException();
    ObjectNotFoundException( const std::string &          _message );
    ObjectNotFoundException( const ObjectNotFoundException & _right );
    virtual ~ObjectNotFoundException();
  };
  
  inline  void ObjectNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ObjectNotFoundException::_setType()
  {
    this -> _type = "ObjectNotFoundException";
  }
  inline   ObjectNotFoundException::ObjectNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ObjectNotFoundException::ObjectNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ObjectNotFoundException::ObjectNotFoundException( const ObjectNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ObjectNotFoundException::~ObjectNotFoundException()
  {
    _finalize();
  }
}
#endif
