#ifndef _DAQBuilderPatternSyntaxException_HH
#define _DAQBuilderPatternSyntaxException_HH
#include <Exception/DAQBuilderIllegalArgumentException.hh>

namespace DAQBuilder
{
  class PatternSyntaxException : public IllegalArgumentException
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    PatternSyntaxException();
    PatternSyntaxException( const std::string &          _message );
    PatternSyntaxException( const PatternSyntaxException & _right );
    virtual ~PatternSyntaxException();
  };
  
  inline  void PatternSyntaxException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
	  _parentClasses.insert("IllegalArgumentException");
  }
  inline void  PatternSyntaxException::_setType()
  {
    this -> _type = "PatternSyntaxException";
  }
  inline   PatternSyntaxException::PatternSyntaxException()
    :IllegalArgumentException()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   PatternSyntaxException::PatternSyntaxException( const std::string & _message )
    :IllegalArgumentException( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   PatternSyntaxException::PatternSyntaxException( const PatternSyntaxException & rhs )
    :IllegalArgumentException( *((IllegalArgumentException*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   PatternSyntaxException::~PatternSyntaxException()
  {
    _finalize();
  }
}
#endif
