#ifndef _DAQBuilderRunNotFoundException_HH
#define _DAQBuilderRunNotFoundException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class RunNotFoundException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    RunNotFoundException();
    RunNotFoundException( const std::string &          _message );
    RunNotFoundException( const RunNotFoundException & _right );
    virtual ~RunNotFoundException();
  };
  
  inline  void RunNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  RunNotFoundException::_setType()
  {
    this -> _type = "RunNotFoundException";
  }
  inline   RunNotFoundException::RunNotFoundException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   RunNotFoundException::RunNotFoundException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   RunNotFoundException::RunNotFoundException( const RunNotFoundException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   RunNotFoundException::~RunNotFoundException()
  {
    _finalize();
  }
}
#endif
