#ifndef _DAQBuilderSameNameBindedException_HH
#define _DAQBuilderSameNameBindedException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class SameNameBindedException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    SameNameBindedException();
    SameNameBindedException( const std::string &          _message );
    SameNameBindedException( const SameNameBindedException & _right );
    virtual ~SameNameBindedException();
  };
  
  inline  void SameNameBindedException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  SameNameBindedException::_setType()
  {
    this -> _type = "SameNameBindedException";
  }
  inline   SameNameBindedException::SameNameBindedException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   SameNameBindedException::SameNameBindedException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   SameNameBindedException::SameNameBindedException( const SameNameBindedException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   SameNameBindedException::~SameNameBindedException()
  {
    _finalize();
  }
}
#endif
