#ifndef _DAQBuilderThreadException_HH
#define _DAQBuilderThreadException_HH
#include <Exception/DAQBuilderException.hh>

namespace DAQBuilder
{
  class ThreadException : public Exception
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ThreadException();
    ThreadException( const std::string &          _message );
    ThreadException( const ThreadException & _right );
    virtual ~ThreadException();
  };
  
  inline  void ThreadException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ThreadException::_setType()
  {
    this -> _type = "ThreadException";
  }
  inline   ThreadException::ThreadException()
    :Exception()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadException::ThreadException( const std::string & _message )
    :Exception( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadException::ThreadException( const ThreadException & rhs )
    :Exception( *((Exception*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadException::~ThreadException()
  {
    _finalize();
  }
}
#endif
