#ifndef _DAQBuilderThreadNotFoundException_HH
#define _DAQBuilderThreadNotFoundException_HH
#include <Exception/DAQBuilderThreadException.hh>

namespace DAQBuilder
{
  class ThreadNotFoundException : public ThreadException
  {
  protected:
    virtual void              _setType();
    virtual void              _setParentClasses();
  public :
    ThreadNotFoundException();
    ThreadNotFoundException( const std::string &          _message );
    ThreadNotFoundException( const ThreadNotFoundException & _right );
    virtual ~ThreadNotFoundException();
  };
  
  inline  void ThreadNotFoundException::_setParentClasses()
  {
	  _parentClasses.insert("Object");
	  _parentClasses.insert("Throwable");
	  _parentClasses.insert("Exception");
  }
  inline void  ThreadNotFoundException::_setType()
  {
    this -> _type = "ThreadNotFoundException";
  }
  inline   ThreadNotFoundException::ThreadNotFoundException()
    :ThreadException()
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadNotFoundException::ThreadNotFoundException( const std::string & _message )
    :ThreadException( _message )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadNotFoundException::ThreadNotFoundException( const ThreadNotFoundException & rhs )
    :ThreadException( *((ThreadException*)&rhs) )
  {
    this->_setType();
    this->_setParentClasses();
  }
  inline   ThreadNotFoundException::~ThreadNotFoundException()
  {
    _finalize();
  }
}
#endif
