#define  D_USE_ROOT
#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <Analizer/DAQBuilderRoot1DHist.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : Root1DHist ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : Root1DHist ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("Root1DHist");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_drawHist;
    a_drawHist.setMethodName("drawDataSection");
    a_drawHist.setArgumentsTypes( std::pair<DString,DString>("DataSection","Draw data"));
    a_drawHist.setReturnTypeName("void");
    aClass.setMethod(a_drawHist);

    Method a_drawHist2;
    a_drawHist2.setMethodName("drawDataRecord");
    a_drawHist2.setArgumentsTypes( std::pair<DString,DString>("DataRecord","Draw data"));
    a_drawHist2.setReturnTypeName("void");
    aClass.setMethod(a_drawHist2);

    Method a_print;
    a_print.setMethodName("print");
    a_print.setArgumentsTypes( std::pair<DString,DString>("String","Print file name"));
    a_print.setReturnTypeName("void");
    aClass.setMethod(a_print);
    
    Method a_setCanvasName;
    a_setCanvasName.setMethodName("setCanvasName");
    a_setCanvasName.setArgumentsTypes( std::pair<DString,DString>("String","Canvas name"));
    a_setCanvasName.setReturnTypeName("void");
    aClass.setMethod(a_setCanvasName);

    Method a_setCanvasTitle;
    a_setCanvasTitle.setMethodName("setCanvasTitle");
    a_setCanvasTitle.setArgumentsTypes( std::pair<DString,DString>("String","Canvas title"));
    a_setCanvasTitle.setReturnTypeName("void");
    aClass.setMethod(a_setCanvasTitle);

    Method a_setCanvasWidth;
    a_setCanvasWidth.setMethodName("setCanvasWidth");
    a_setCanvasWidth.setArgumentsTypes( std::pair<DString,DString>("Integer","Canvas width"));
    a_setCanvasWidth.setReturnTypeName("void");
    aClass.setMethod(a_setCanvasWidth);

    Method a_setCanvasHeight;
    a_setCanvasHeight.setMethodName("setCanvasHeight");
    a_setCanvasHeight.setArgumentsTypes( std::pair<DString,DString>("Integer","Canvas height"));
    a_setCanvasHeight.setReturnTypeName("void");
    aClass.setMethod(a_setCanvasHeight);
    
    Method a_setNumBins;
    a_setNumBins.setMethodName("setNumBins");
    a_setNumBins.setArgumentsTypes( std::pair<DString,DString>("Integer","number of bins"));
    a_setNumBins.setReturnTypeName("void");
    aClass.setMethod(a_setNumBins);

    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isChecked )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new Root1DHist();
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((Root1DHist*)instance._heldObject)->toString());
      }
    else if(methodName=="drawDataSection")
      {
        ((Root1DHist*)instance.get())->drawHist(*((DataSection*)arguments[0].get()));
      }
    else if(methodName=="drawDataRecord")
      {
        ((Root1DHist*)instance.get())->drawHist(*((DataRecord*)arguments[0].get()));
      }
    else if(methodName=="print")
      {
        ((Root1DHist*)instance.get())->printHist(arguments[0]->toString());
      }
    else if(methodName=="setCanvasName")
      {
        ((Root1DHist*)instance.get())->setCanvasName(arguments[0]->toString());
      }
    else if(methodName=="setCanvasTitle")
      {
        ((Root1DHist*)instance.get())->setCanvasTitle(arguments[0]->toString());
      }
    else if(methodName=="setCanvasWidth")
      {
        ((Root1DHist*)instance.get())->setCanvasWidth(((Integer*)arguments[0].get())->get());
      }
    else if(methodName=="setCanvasHeight")
      {
        ((Root1DHist*)instance.get())->setCanvasHeight(((Integer*)arguments[0].get())->get());
      }
    else if(methodName=="setNumBins")
      {
        ((Root1DHist*)instance.get())->setNumBins(((Integer*)arguments[0].get())->get());
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
