#define  D_USE_ROOT
#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Analizer/DAQBuilderRootFile.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : RootFile ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : RootFile ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("RootFile");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setArgumentsTypes( std::pair<DString,DString>("String","File name "));
    a_new.setReturnTypeName("void");
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_write;
    a_write.setMethodName("write");
    a_write.setArgumentsTypes( std::pair<DString,DString>("DataRecord","datarecord 2 .root file "));
    a_write.setReturnTypeName("void");
    aClass.setMethod(a_write);

    Method a_setTreeTitle;
    a_setTreeTitle.setMethodName("setTreeTitle");
    a_setTreeTitle.setArgumentsTypes( std::pair<DString,DString>("String","Tree title"));
    a_setTreeTitle.setReturnTypeName("void");
    aClass.setMethod(a_setTreeTitle);

    Method a_setTreeName;
    a_setTreeName.setMethodName("setTreeName");
    a_setTreeName.setArgumentsTypes( std::pair<DString,DString>("String","Tree name"));
    a_setTreeName.setReturnTypeName("void");
    aClass.setMethod(a_setTreeName);

    Method a_setFileName;
    a_setFileName.setMethodName("setFileName");
    a_setFileName.setArgumentsTypes( std::pair<DString,DString>("String","File name"));
    a_setFileName.setReturnTypeName("void");
    aClass.setMethod(a_setFileName);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		 const DString& methodName ,
		 Arguments&     arguments,
		 Instance&      returnValue ,
		 const DBool&   isChecked )
    throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new RootFile(arguments[0]->toString());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((RootFile*)instance._heldObject)->toString());
      }
    else if(methodName=="write")
      {
        ((RootFile*)instance.get())->write(*((DataRecord*)arguments[0].get()));
      }
    else if(methodName=="setTreeTitle")
      {
        ((RootFile*)instance.get())->setTreeTitle(arguments[0]->toString());
      }
    else if(methodName=="setTreeName")
      {
        ((RootFile*)instance.get())->setTreeName(arguments[0]->toString());
      }
    else if(methodName=="setFileName")
      {
        ((RootFile*)instance.get())->setFileName(arguments[0]->toString());
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
