#include <Instance/DAQBuilderInstance.hh>
#include <System/DAQBuilderSystem.hh>
#include <System/DAQBuilderClassLoader.hh>
#include <System/DAQBuilderObjectRegistry.hh>
#include <System/IO/DAQBuilderCheckedOutputStream.hh>
#include <System/IO/DAQBuilderFileOutputStream.hh>
#include <System/IO/DAQBuilderCheckedInputStream.hh>
#include <System/IO/DAQBuilderFileInputStream.hh>
#include <System/IO/DAQBuilderGZipInputStream.hh>
#include <System/IO/DAQBuilderGZipOutputStream.hh>
#include <System/IO/DAQBuilderBufferedInputStream.hh>
#include <System/IO/DAQBuilderBufferedOutputStream.hh>
#include <Class/DAQBuilderClass.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <Primitives/DAQBuilderShort.hh>
#include <Primitives/DAQBuilderLong.hh>
#include <Primitives/DAQBuilderUnsignedInteger.hh>
#include <Primitives/DAQBuilderUnsignedShort.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderCharacter.hh>
#include <Primitives/DAQBuilderUnsignedCharacter.hh>
#include <Primitives/DAQBuilderDouble.hh>
#include <Primitives/DAQBuilderFloat.hh>
#include <Primitives/DAQBuilderBoolean.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataSection.hh>
#include <DataRecord/DAQBuilderDataSegment.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/DAQBuilderSoftwareSwitchRegister.hh>
#include <Modules/DAQBuilderReadoutList.hh>

namespace DAQBuilder 
{
/*  static DataRecord             _dataRecord;
  static DataSection            _dataSection;
  static DataSegment            _dataSegment;
  static DataElement            _dataElement;
  static SoftwareSwitchRegister _softwareSwitchRegister;
  static ReadoutList            _readoutList;
  static FileOutputStream       _fileOutputStream(".");
  static CheckedOutputStream    _checkedOutputStream(&_fileOutputStream);
  static FileInputStream        _fileInputStream(".");
  static CheckedInputStream     _checkedInputStream(&_fileInputStream);
  static GZipOutputStream       _gzipOutputStream(&_checkedOutputStream);
  static GZipInputStream        _gzipInputStream(&_checkedInputStream);
  static BufferedOutputStream   _bufferedOutputStream(&_gzipOutputStream);
  static BufferedInputStream    _bufferedInputStream(&_gzipInputStream);
*/
  DBool             Instance::equals( const Instance & o )     const 
  {
    DBool  aBool = *((Instance*)this) == *((Instance*)&o);
    return aBool;
  }
  
  DBool             Instance::equals( const Object   * o )     const 
  {
    if(!findParent(_type,o))
      return false;
    return equals(*((Instance*)o));
  }
  DBool   Instance::operator   ==(const Instance & right ) const 
  {
    DBool aBool = *((Object*)this) ==  *((Object*)&right);
    aBool      |= _heldObject -> operator==(*right._heldObject);
    return aBool;
  }
  DBool   Instance::operator   !=(const Instance & right ) const 
  {
    DBool aBool = *((Object*)this) !=  *((Object*)&right);
    aBool      |= _heldObject -> operator!=(*right._heldObject);
    return aBool;
  }
  
  Instance::Instance( Object * heldObject  )
    :Object(),_heldObject(heldObject)
  {
    _setType();
    _setParentClasses();
    //    _countUp();
  }
  Instance::Instance( Object & heldObject  )
    :Object(),_heldObject(&heldObject)
  {
    _setType();
    _setParentClasses();
    //    _countUp();
  }
  Instance::Instance( const Instance & right )
    :Object(*((Object*)&right)),_objectName(right._objectName),
     _class(right._class),_heldObject(right._heldObject)
  {
    _countUp();
  }

   Instance::Instance( const DShort& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Short(i) );
  }
   Instance::Instance( const DInt& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Integer(i) );
  }
   Instance::Instance( const DLong& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Long(i) );
  }
   Instance::Instance( const DUShort& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new UnsignedShort(i) );
  }
   Instance::Instance( const DUInt& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new UnsignedInteger(i) );
  }
   Instance::Instance( const DULong& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new UnsignedLong(i) );
  }
   Instance::Instance( const DFloat& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Float(i) );
  }
   Instance::Instance( const DDouble& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Double(i) );
  }
   Instance::Instance( const DChar& i )
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Character(i) );
  }
   Instance::Instance( const DUChar& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new UnsignedCharacter(i) );
  }
   Instance::Instance( const DBool& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new Boolean(i) );
  }
   Instance::Instance( const DString& i)
    :Object(),_heldObject(NULL)
  {
    _setType();
    _setParentClasses();
    operator=( new String(i) );
  }

  void              Instance::_countUp()
  {
    if(!isNull()){
      /*System::out.print("Count "+_objectName);
      System::out.print(_heldObject->getReferenceCount());
      System::out.print(" -> ");*/
      _heldObject -> _upReferenceCount();
      //System::out.println(_heldObject->getReferenceCount());
    }
  }
  void              Instance::_countDown()
  {
    if(!isNull()){
      /*System::out.print("Count "+_objectName);
      System::out.print(_heldObject->getReferenceCount());
      System::out.print(" -> ");*/
      _heldObject -> _downReferenceCount();
      //System::out.println(_heldObject->getReferenceCount());
      if( _heldObject -> getReferenceCount() == 0  ){
    /*if(!_objectName.empty())
    System::out.print("Delete..."+_objectName);*/
        delete _heldObject;
        _heldObject = NULL;
    /*if(!_objectName.empty())
      System::out.println("...[OK] ");*/
        return ;
      }
    }
  }
  Instance::~Instance()
  {
  //  System::out.print("Delete..."+_objectName);
    _countDown();
    _finalize();
   // System::out.println("...[OK]");
  }
  
  void          Instance::setObjectName( const DString & objectName )
  {
   _objectName = objectName;
  }
  Instance& Instance::operator   =(const Instance & right )
  {
    *((Object*)this)  =    *((Object*)&right);
    if((&right) != this && _heldObject != right._heldObject )
      {
	_countDown();
	_objectName  = right._objectName;
	_class       = right._class;
	_heldObject  = right._heldObject;
        _countUp();
      }
    return *this;
  }
  
  Instance& Instance::operator   =(Object   * right )
  {
    _countDown();
    _heldObject = right;
    synchronizedClass();
    //_countUp();
    return *this;
  }
  Instance& Instance::operator   =(Object   & right )
  {
    _countDown();
    _heldObject = &right;
    synchronizedClass();
    _countUp();
    return *this;
  }
  Instance& Instance::operator   =( const DShort& i  )
  {
    return operator=( new Short(i));
  }
  Instance& Instance::operator   =( const DInt&  i )
  {
    return operator=( new Integer(i));
  }
  Instance& Instance::operator   =( const DLong& i )
  {
    return operator=( new Long(i));
  }
  Instance& Instance::operator   =( const DUShort& i )
  {
    return operator=( new UnsignedShort(i));
  }
  Instance& Instance::operator   =( const DUInt& i )
  {
    return operator=( new UnsignedInteger(i));
  }
  Instance& Instance::operator   =( const DULong& i )
  {
    return operator=( new UnsignedLong(i));
  }
  Instance& Instance::operator   =( const DFloat& i )
  {
    return operator=( new Float(i));
    return *this;
  }
    Instance& Instance::operator   =( const DDouble& i )
  {
    return operator=( new Double(i));
    return *this;
  }
  Instance& Instance::operator   =( const DChar& i )
  {
    return operator=( new Character(i));
    return *this;
  }
  Instance& Instance::operator   =( const DUChar& i )
  {
    return operator=( new UnsignedCharacter(i));
    return *this;
  }
  Instance& Instance::operator   =( const DBool& i )
  {
    return operator=( new Boolean(i));
  }
  Instance& Instance::operator   =( const DString& i )
  {
    return operator=( new String(i));
  }
  Object&       Instance::operator*()
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","Instance::operator*()");
      throw e;
    }
    return *_heldObject;
  }
  
  const Object& Instance::operator*() const 
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","Instance::operator*() const ");
      throw e;
    }
    return *_heldObject;
  }
  
  Object*       Instance::operator->()
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","Instance::operator->()");
      throw e;
    }
    return _heldObject;
  }
  const Object* Instance::operator->() const 
    throw(NullPointerException * )
  {
    if(isNull()){
      NullPointerException * e 
	= new NullPointerException("Pointer _heldObject is NULL ");
      e -> insert("Location","Instance::operator->() const");
      throw e;
    }
    return _heldObject;
  }
  
  const Class&  Instance::getClass() const
  {
    return _class;
  }
  
  Object*       Instance::get()
  {
    return _heldObject;
  }
  const Object* Instance::get() const 
  {
    return _heldObject;
  }
  DBool         Instance::isNull() const 
  {
    return _heldObject == NULL;
  }
  const DString     Instance::toString() const
  {
    DString aString;
    aString +=  "ObjectName        : ";
    aString +=  _objectName;
    aString +=  "\n";
    aString +=  _class.toString();
    aString +=  "\n";
    if(!isNull()){
      aString +=  "String Expression :\n";
      aString +=  _heldObject->toString();
      aString +=  "\n";
      aString +=  "Count             : ";
      aString +=  String::digitToString(_heldObject->getReferenceCount());
    }
    return aString;
  }  
  void    Instance::_checkMethodArguments( const Method& method ,
					   Arguments&    arguments)
    throw(Exception * )
  {
    if( method.getMethodName() != "new" && _heldObject == NULL){
      NullPointerException* e = 
	new NullPointerException("_heldObject is NULL");
        e->insert("Location","Instance::_checkMethodArguments()");
        throw e;
    }
    if(arguments.size() !=method.getNumberOfArguments()){
      IllegalArgumentException* e = 
	new IllegalArgumentException("Number of arguments is illegal");
      e->insert("Usage",method.toString());
      e->insert("Location","Instance::_checkMethodArguments()");
      throw e;
    }
    std::vector< std::pair<DString,DString> >::const_iterator methodIter 
      = method.getArgumentsTypesIterator();
    std::vector< Instance >::const_iterator     argIter 
      = arguments.begin();
    for(;argIter != arguments.end();methodIter++, argIter++)
      {
        Object * aTmpObject = (Object*)((*argIter).get());
        //std::cout<<"<tmpObj>"<<aTmpObject<<std::endl;
        DString  aHopedType = methodIter->first;
        if(!findParent(aHopedType, aTmpObject))
	  {
	    IllegalArgumentException* e = 
	      new IllegalArgumentException("Type illegal");
	    e->insert("You use     ",aTmpObject->getType());
	    e->insert("But we hope ",aHopedType);
	    e->insert("Usage       ",method.toString());
	    e->insert("Location","Instance::_checkMethodArguments()");
	    throw e;
	  }
      }/*
    if( method.getReturnTypeName() != "void" )
      {

        if(!findParent(method.getReturnTypeName(),(Object*)returnValue.get()))
	  {
	    IllegalArgumentException* e = 
	      new IllegalArgumentException("Retrun value type  illegal");
	    e->insert("You use     ",returnValue.get()->getType());
	    e->insert("But we hope ",method.getReturnTypeName());
	    e->insert("Usage       ",method.toString());
	    e->insert("Location","Instance::_checkMethodArguments()");
	    throw e;
	  }
	  }*/
  }
  void    Instance::synchronizedClass()
      throw(ClassNotFoundException* )
  {
    if(!isNull() && _heldObject->getType() != _class.getClassName() ){
    _lock();
    _class      = ClassLoader::getClass(_heldObject->getType());
    _unLock();
   }
  }   
}
