#ifndef __DAQBuilderInstance_HH__
#define __DAQBuilderInstance_HH__
#include <DAQBuilderObject.hh>
#include <Class/DAQBuilderClass.hh>
#include <Exception/DAQBuilderNullPointerException.hh>
#include <Exception/DAQBuilderIllegalArgumentException.hh>
#include <Exception/DAQBuilderClassNotFoundException.hh>

void _init();
void _fini();
namespace DAQBuilder 
{
  class Method;
  class Instance : public Object 
  {
  protected:
    void              _setType();
    void              _setParentClasses();
  protected:
    DString                    _objectName;
    Class                      _class;
    Object    *                _heldObject;
  public:
    DBool             equals( const Instance & o )     const ;
    DBool             equals( const Object   * o )     const ;
  public :
    explicit Instance( Object * _heldObject = NULL );
    explicit Instance( Object & _heldObject );
    Instance( const Instance& right );
    
    explicit Instance( const DShort&);
    explicit Instance( const DInt&);
    explicit Instance( const DLong&);
    explicit Instance( const DUShort&);
    explicit Instance( const DUInt&);
    explicit Instance( const DULong&);
    explicit Instance( const DFloat&);
    explicit Instance( const DDouble&);
    explicit Instance( const DChar&);
    explicit Instance( const DUChar&);
    explicit Instance( const DBool&);
    explicit Instance( const DString&);
    
    ~Instance();
  protected:
    void                      _countDown();
    void                      _countUp();
    // void              _makeClass(){;}
  public:    
    Instance& operator   =(const Instance & right );
    virtual DBool   operator   ==(const Instance & right ) const ;
    virtual DBool   operator   !=(const Instance & right ) const ;
    Instance& operator   =(Object         * right );
    Instance& operator   =(Object&          right );
    
    Instance& operator   =( const DShort&);
    Instance& operator   =( const DInt&);
    Instance& operator   =( const DLong&);
    Instance& operator   =( const DUShort&);
    Instance& operator   =( const DUInt&);
    Instance& operator   =( const DULong&);
    Instance& operator   =( const DFloat&);
    Instance& operator   =( const DDouble&);
    Instance& operator   =( const DChar&);
    Instance& operator   =( const DUChar&);
    Instance& operator   =( const DBool&);
    Instance& operator   =( const DString&);
    
    Object&       operator*() 
      throw(NullPointerException * );
    const Object& operator*() const 
      throw(NullPointerException * );
    
    Object*       operator->()
      throw(NullPointerException * );
    const Object* operator->() const 
      throw(NullPointerException * );
    
  public:
    const DString     toString() const;
    Object*       get();
    const Object* get() const ;
    
    DBool         isNull() const ;
    const Class&    getClass() const; 
    void            setObjectName( const DString & _objectName );
    const DString&  getObjectName() const ;
    void              synchronizedClass()
      throw(ClassNotFoundException* );
    
    friend void  fExecute( Instance     & instance ,
			   const DString& methodName ,
			   Arguments&     arguments,
			   Instance&      returnValue ,
			   const DBool&   isChecked )
      throw(Exception *);
    
    friend void makeClass( Instance     & instance );
    
  protected:
    void    _checkMethodArguments( const Method& method ,
				   Arguments&    arguments)
      throw(Exception * );
  };
  inline void   Instance::_setParentClasses()
  {
    _parentClasses.insert("Object");
  }
  inline void   Instance::_setType()
  {
    this -> _type = "Instance";
  }
  inline const DString&  Instance::getObjectName() const 
  {
    return _objectName;
  }
}
extern "C"{
  void     execute( DAQBuilder::Instance     & instance ,
		    const DAQBuilder::DString& methodName ,
		    DAQBuilder::Arguments&     arguments,
		    DAQBuilder::Instance&      returnValue ,
		    const DAQBuilder::DBool&   isChecked )
    throw(DAQBuilder::Exception *);
  DAQBuilder::Instance   getInstance();
}
#endif
