#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : DataElement ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : DataElement ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("DataElement");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");


    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");


    aClass.setMethod(a_new);
    aClass.setMethod(a_toString);
    
    instance._class = aClass;
  }

 void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new DataElement();
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((DataElement*)instance._heldObject)->toString());
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
   DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
