#include <Instance/DAQBuilderInstance.hh>
#include <Primitives/DAQBuilderString.hh>
#include <Primitives/DAQBuilderUnsignedLong.hh>
#include <Primitives/DAQBuilderInteger.hh>
#include <DataRecord/DAQBuilderDataRecord.hh>
#include <DataRecord/DAQBuilderDataElement.hh>
#include <Modules/CAMAC/DAQBuilderCAMACCrateController.hh>
#include <Class/DAQBuilderMethod.hh>
#include <Class/DAQBuilderField.hh>
#include <System/DAQBuilderSystem.hh>
#include <Exception/DAQBuilderException.hh>

void _init()
{
 DAQBuilder::System::out.println("Loaded : CAMACCrateController ");
} 
void _fini()
{
 DAQBuilder::System::out.println("UnLoaded : CAMACCrateController ");
}
namespace DAQBuilder 
{
  void makeClass( Instance& instance )
  {
    Class  aClass("CAMACCrateController");
    Method a_new;
    a_new.setMethodName("new");
    a_new.setReturnTypeName("void");
    a_new.setArgumentsTypes( std::pair<DString,DString>("String","device node name ") );
    aClass.setMethod(a_new);

    Method a_toString;
    a_toString.setMethodName("toString");
    a_toString.setReturnTypeName("String");
    aClass.setMethod(a_toString);

    Method a_open;
    a_open.setMethodName("open");
    a_open.setReturnTypeName("void");
    aClass.setMethod(a_open);

    Method a_close;
    a_close.setMethodName("close");
    a_close.setReturnTypeName("void");
    aClass.setMethod(a_close);

    Method a_reset;
    a_reset.setMethodName("reset");
    a_reset.setReturnTypeName("void");
    aClass.setMethod(a_reset);

    Method a_initialize;
    a_initialize.setMethodName("initialize");
    a_initialize.setReturnTypeName("void");
    aClass.setMethod(a_initialize);

    Method a_update;
    a_update.setMethodName("update");
    a_update.setReturnTypeName("void");
    aClass.setMethod(a_update);

    Method a_clear;
    a_clear.setMethodName("clear");
    a_clear.setReturnTypeName("void");
    aClass.setMethod(a_clear);

    Method a_enableInterrupt;
    a_enableInterrupt.setMethodName("enableInterrupt");
    a_enableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_enableInterrupt);

    Method a_disableInterrupt;
    a_disableInterrupt.setMethodName("disableInterrupt");
    a_disableInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_disableInterrupt);

    Method a_enableOwnInterrupt;
    a_enableOwnInterrupt.setMethodName("enableOwnInterrupt");
    a_enableOwnInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_enableOwnInterrupt);

    Method a_disableOwnInterrupt;
    a_disableOwnInterrupt.setMethodName("disableOwnInterrupt");
    a_disableOwnInterrupt.setReturnTypeName("void");
    aClass.setMethod(a_disableOwnInterrupt);
    
    instance._class = aClass;
  }

  void fExecute( Instance&      instance ,
		     const DString& methodName ,
		     Arguments&     arguments,
		 Instance&      returnValue ,
		     const DBool&   isChecked )
      throw(Exception *)
  {
    Instance& aInstance=returnValue;
    if(!isChecked)
      instance._checkMethodArguments(instance._class.getMethod(methodName),
			    arguments);
     
    if(methodName=="new")
      {
	instance  = new CAMACCrateController( arguments[0]->toString());
      }
    else if(methodName=="toString")
      {
	aInstance = new String(((CAMACCrateController*)instance._heldObject)->toString());
      }
    else if(methodName=="close")
      {
	((CAMACCrateController*)instance.get())->close();
      }
    else if(methodName=="open")
      {
	((CAMACCrateController*)instance.get())->open();
      }
    else if(methodName=="reset")
      {
	((CAMACCrateController*)instance.get())->reset();
      }
    else if(methodName=="initialize")
      {
	((CAMACCrateController*)instance.get())->initialize();
      }
    else if(methodName=="update")
      {
	((CAMACCrateController*)instance.get())->update();
      }
    else if(methodName=="clear")
      {
	((CAMACCrateController*)instance.get())->clear();
      }
    else if(methodName=="enableInterrupt")
      {
	((CAMACCrateController*)instance.get())->enableInterrupt();
      }
    else if(methodName=="disableInterrupt")
      {
	((CAMACCrateController*)instance.get())->disableInterrupt();
      }
    else if(methodName=="enableOwnInterrupt")
      {
	((CAMACCrateController*)instance.get())->enableOwnInterrupt();
      }
    else if(methodName=="disableOwnInterrupt")
      {
	((CAMACCrateController*)instance.get())->disableOwnInterrupt();
      }
  }
}
 extern "C"{
    void   execute( DAQBuilder::Instance&      instance ,
				 const DAQBuilder::DString& methodName ,
				 DAQBuilder::Arguments&     arguments,
				 DAQBuilder::Instance&     returnValue,
				 const   DAQBuilder::DBool&   isChecked )
     throw(DAQBuilder::Exception *)
   {
     return DAQBuilder::fExecute(instance,methodName,arguments,returnValue,isChecked);
   }
 DAQBuilder::Instance  getInstance()
 {
   DAQBuilder::Instance  aInstance;
   DAQBuilder::makeClass(aInstance);
   return  aInstance; 
 }
}
